$(document).ready(function () {
    'use strict';
    let icons = [
        'ti-flickr',
        'ti-flickr-alt',
        'ti-instagram',
        'ti-google',
        'ti-github',
        'ti-facebook',
        'ti-dropbox',
        'ti-dropbox-alt',
        'ti-dribbble',
        'ti-apple',
        'ti-android',
        'ti-yahoo',
        'ti-trello',
        'ti-stack-overflow',
        'ti-soundcloud',
        'ti-sharethis',
        'ti-sharethis-alt',
        'ti-reddit',
        'ti-microsoft',
        'ti-microsoft-alt',
        'ti-linux',
        'ti-jsfiddle',
        'ti-joomla',
        'ti-html5',
        'ti-css3',
        'ti-drupal',
        'ti-wordpress',
        'ti-tumblr',
        'ti-tumblr-alt',
        'ti-skype',
        'ti-youtube',
        'ti-vimeo',
        'ti-vimeo-alt',
        'ti-twitter',
        'ti-twitter-alt',
        'ti-linkedin',
        'ti-pinterest',
        'ti-pinterest-alt',
        'ti-themify-logo',
        'ti-themify-favicon',
        'ti-themify-favicon-alt',
        'fab fa-500px',
        'fab fa-accessible-icon',
        'fab fa-accusoft',
        'fab fa-acquisitions-incorporated',
        'fa fa-address-book',
        'fa fa-address-card',
        'fa fa-adjust',
        'fab fa-adn',
        'fab fa-adobe',
        'fab fa-adversal',
        'fab fa-affiliatetheme',
        'fa fa-air-freshener',
        'fab fa-airbnb',
        'fab fa-algolia',
        'fa fa-align-center',
        'fa fa-align-justify',
        'fa fa-align-left',
        'fa fa-align-right',
        'fab fa-alipay',
        'fa fa-allergies',
        'fab fa-amazon',
        'fab fa-amazon-pay',
        'fa fa-ambulance',
        'fa fa-american-sign-language-interpreting',
        'fab fa-amilia',
        'fa fa-anchor',
        'fab fa-android',
        'fab fa-angellist',
        'fa fa-angle-double-down',
        'fa fa-angle-double-left',
        'fa fa-angle-double-right',
        'fa fa-angle-double-up',
        'fa fa-angle-down',
        'fa fa-angle-left',
        'fa fa-angle-right',
        'fa fa-angle-up',
        'fa fa-angry',
        'fab fa-angrycreative',
        'fab fa-angular',
        'fa fa-ankh',
        'fab fa-app-store',
        'fab fa-app-store-ios',
        'fab fa-apper',
        'fab fa-apple',
        'fa fa-apple-alt',
        'fab fa-apple-pay',
        'fa fa-archive',
        'fa fa-archway',
        'fa fa-arrow-alt-circle-down',
        'fa fa-arrow-alt-circle-left',
        'fa fa-arrow-alt-circle-right',
        'fa fa-arrow-alt-circle-up',
        'fa fa-arrow-circle-down',
        'fa fa-arrow-circle-left',
        'fa fa-arrow-circle-right',
        'fa fa-arrow-circle-up',
        'fa fa-arrow-down',
        'fa fa-arrow-left',
        'fa fa-arrow-right',
        'fa fa-arrow-up',
        'fa fa-arrows-alt',
        'fa fa-arrows-alt-h',
        'fa fa-arrows-alt-v',
        'fab fa-artstation',
        'fa fa-assistive-listening-systems',
        'fa fa-asterisk',
        'fab fa-asymmetrik',
        'fa fa-at',
        'fa fa-atlas',
        'fab fa-atlassian',
        'fa fa-atom',
        'fab fa-audible',
        'fa fa-audio-description',
        'fab fa-autoprefixer',
        'fab fa-avianex',
        'fab fa-aviato',
        'fa fa-award',
        'fab fa-aws',
        'fa fa-baby',
        'fa fa-baby-carriage',
        'fa fa-backspace',
        'fas fa-parking',
        'fa fa-backward',
        'fa fa-bacon',
        'fa fa-balance-scale',
        'fa fa-balance-scale-left',
        'fa fa-balance-scale-right',
        'fa fa-ban',
        'fa fa-band-aid',
        'fab fa-bandcamp',
        'fa fa-barcode',
        'fa fa-bars',
        'fa fa-baseball-ball',
        'fa fa-basketball-ball',
        'fa fa-bath',
        'fa fa-battery-empty',
        'fa fa-battery-full',
        'fa fa-battery-half',
        'fa fa-battery-quarter',
        'fa fa-battery-three-quarters',
        'fab fa-battle-net',
        'fa fa-bed',
        'fa fa-beer',
        'fab fa-behance',
        'fab fa-behance-square',
        'fa fa-bell',
        'fa fa-bell-slash',
        'fa fa-bezier-curve',
        'fa fa-bible',
        'fa fa-bicycle',
        'fab fa-bimobject',
        'fa fa-binoculars',
        'fa fa-biohazard',
        'fa fa-birthday-cake',
        'fab fa-bitbucket',
        'fab fa-bitcoin',
        'fab fa-bity',
        'fab fa-black-tie',
        'fab fa-blackberry',
        'fa fa-blender',
        'fa fa-blender-phone',
        'fa fa-blind',
        'fa fa-blog',
        'fab fa-blogger',
        'fab fa-blogger-b',
        'fab fa-bluetooth',
        'fab fa-bluetooth-b',
        'fa fa-bold',
        'fa fa-bolt',
        'fa fa-bomb',
        'fa fa-bone',
        'fa fa-bong',
        'fa fa-book',
        'fa fa-book-dead',
        'fa fa-book-medical',
        'fa fa-book-open',
        'fa fa-book-reader',
        'fa fa-bookmark',
        'fab fa-bootstrap',
        'fa fa-bowling-ball',
        'fa fa-box',
        'fa fa-box-open',
        'fa fa-boxes',
        'fa fa-braille',
        'fa fa-brain',
        'fa fa-bread-slice',
        'fa fa-briefcase',
        'fa fa-briefcase-medical',
        'fa fa-broadcast-tower',
        'fa fa-broom',
        'fa fa-brush',
        'fab fa-btc',
        'fab fa-buffer',
        'fa fa-bug',
        'fa fa-building',
        'fa fa-bullhorn',
        'fa fa-bullseye',
        'fa fa-burn',
        'fab fa-buromobelexperte',
        'fa fa-bus',
        'fas fa-bus',
        'fa fa-bus-alt',
        'fa fa-business-time',
        'fab fa-buysellads',
        'fa fa-calculator',
        'fa fa-calendar',
        'fa fa-calendar-alt',
        'fa fa-calendar-check',
        'fa fa-calendar-day',
        'fa fa-calendar-minus',
        'fa fa-calendar-plus',
        'fa fa-calendar-times',
        'fa fa-calendar-week',
        'fa fa-camera',
        'fa fa-camera-retro',
        'fa fa-campground',
        'fab fa-canadian-maple-leaf',
        'fa fa-candy-cane',
        'fa fa-cannabis',
        'fa fa-capsules',
        'fa fa-car',
        'fa fa-car-alt',
        'fa fa-car-battery',
        'fa fa-car-crash',
        'fa fa-car-side',
        'fa fa-caret-down',
        'fa fa-caret-left',
        'fa fa-caret-right',
        'fa fa-caret-square-down',
        'fa fa-caret-square-left',
        'fa fa-caret-square-right',
        'fa fa-caret-square-up',
        'fa fa-caret-up',
        'fa fa-carrot',
        'fa fa-cart-arrow-down',
        'fa fa-cart-plus',
        'fas fa-cart-plus',
        'fa fa-cash-register',
        'fa fa-cat',
        'fab fa-cc-amazon-pay',
        'fab fa-cc-amex',
        'fab fa-cc-apple-pay',
        'fab fa-cc-diners-club',
        'fab fa-cc-discover',
        'fab fa-cc-jcb',
        'fab fa-cc-mastercard',
        'fab fa-cc-paypal',
        'fab fa-cc-stripe',
        'fab fa-cc-visa',
        'fab fa-centercode',
        'fab fa-centos',
        'fa fa-certificate',
        'fa fa-chair',
        'fa fa-chalkboard',
        'fa fa-chalkboard-teacher',
        'fa fa-charging-station',
        'fa fa-chart-area',
        'fa fa-chart-bar',
        'fa fa-chart-line',
        'fa fa-chart-pie',
        'fa fa-check',
        'fas fa-check',
        'fa fa-check-circle',
        'fa fa-check-double',
        'fa fa-check-square',
        'fa fa-cheese',
        'fa fa-chess',
        'fa fa-chess-bishop',
        'fa fa-chess-board',
        'fa fa-chess-king',
        'fa fa-chess-knight',
        'fa fa-chess-pawn',
        'fa fa-chess-queen',
        'fa fa-chess-rook',
        'fa fa-chevron-circle-down',
        'fa fa-chevron-circle-left',
        'fa fa-chevron-circle-right',
        'fa fa-chevron-circle-up',
        'fa fa-chevron-down',
        'fa fa-chevron-left',
        'fa fa-chevron-right',
        'fa fa-chevron-up',
        'fa fa-child',
        'fab fa-chrome',
        'fab fa-chromecast',
        'fa fa-church',
        'fa fa-circle',
        'fa fa-circle-notch',
        'fa fa-city',
        'fa fa-clinic-medical',
        'fa fa-clipboard',
        'fa fa-clipboard-check',
        'fa fa-clipboard-list',
        'fa fa-clock',
        'fa fa-clone',
        'fa fa-closed-captioning',
        'fa fa-cloud',
        'fa fa-cloud-download-alt',
        'fa fa-cloud-meatball',
        'fa fa-cloud-moon',
        'fa fa-cloud-moon-rain',
        'fa fa-cloud-rain',
        'fa fa-cloud-showers-heavy',
        'fa fa-cloud-sun',
        'fa fa-cloud-sun-rain',
        'fa fa-cloud-upload-alt',
        'fab fa-cloudscale',
        'fab fa-cloudsmith',
        'fab fa-cloudversify',
        'fa fa-cocktail',
        'fa fa-code',
        'fa fa-code-branch',
        'fab fa-codepen',
        'fab fa-codiepie',
        'fa fa-coffee',
        'fa fa-cog',
        'fa fa-cogs',
        'fa fa-coins',
        'fa fa-columns',
        'fa fa-comment',
        'fa fa-comment-alt',
        'fa fa-comment-dollar',
        'fa fa-comment-dots',
        'fa fa-comment-medical',
        'fa fa-comment-slash',
        'fa fa-comments',
        'fa fa-comments-dollar',
        'fa fa-compact-disc',
        'fa fa-compass',
        'fa fa-compress',
        'fa fa-compress-arrows-alt',
        'fa fa-concierge-bell',
        'fab fa-confluence',
        'fab fa-connectdevelop',
        'fab fa-contao',
        'fa fa-cookie',
        'fa fa-cookie-bite',
        'fa fa-copy',
        'fa fa-copyright',
        'fab fa-cotton-bureau',
        'fa fa-couch',
        'fab fa-cpanel',
        'fab fa-creative-commons',
        'fab fa-creative-commons-by',
        'fab fa-creative-commons-nc',
        'fab fa-creative-commons-nc-eu',
        'fab fa-creative-commons-nc-jp',
        'fab fa-creative-commons-nd',
        'fab fa-creative-commons-pd',
        'fab fa-creative-commons-pd-alt',
        'fab fa-creative-commons-remix',
        'fab fa-creative-commons-sa',
        'fab fa-creative-commons-sampling',
        'fab fa-creative-commons-sampling-plus',
        'fab fa-creative-commons-share',
        'fab fa-creative-commons-zero',
        'fa fa-credit-card',
        'fab fa-critical-role',
        'fa fa-crop',
        'fa fa-crop-alt',
        'fa fa-cross',
        'fa fa-crosshairs',
        'fa fa-crow',
        'fa fa-crown',
        'fa fa-crutch',
        'fab fa-css3',
        'fab fa-css3-alt',
        'fa fa-cube',
        'fa fa-cubes',
        'fa fa-cut',
        'fab fa-cuttlefish',
        'fab fa-d-and-d',
        'fab fa-d-and-d-beyond',
        'fab fa-dashcube',
        'fa fa-database',
        'fa fa-deaf',
        'fab fa-delicious',
        'fa fa-democrat',
        'fab fa-deploydog',
        'fab fa-deskpro',
        'fa fa-desktop',
        'fab fa-dev',
        'fab fa-deviantart',
        'fa fa-dharmachakra',
        'fab fa-dhl',
        'fa fa-diagnoses',
        'fab fa-diaspora',
        'fa fa-dice',
        'fa fa-dice-d20',
        'fa fa-dice-d6',
        'fa fa-dice-five',
        'fa fa-dice-four',
        'fa fa-dice-one',
        'fa fa-dice-six',
        'fa fa-dice-three',
        'fa fa-dice-two',
        'fab fa-digg',
        'fab fa-digital-ocean',
        'fa fa-digital-tachograph',
        'fa fa-directions',
        'fab fa-discord',
        'fab fa-discourse',
        'fa fa-divide',
        'fa fa-dizzy',
        'fa fa-dna',
        'fab fa-dochub',
        'fab fa-docker',
        'fa fa-dog',
        'fa fa-dollar-sign',
        'fa fa-dolly',
        'fa fa-dolly-flatbed',
        'fa fa-donate',
        'fa fa-door-closed',
        'fa fa-door-open',
        'fa fa-dot-circle',
        'fa fa-dove',
        'fa fa-download',
        'fab fa-draft2digital',
        'fa fa-drafting-compass',
        'fa fa-dragon',
        'fa fa-draw-polygon',
        'fab fa-dropbox',
        'fa fa-drum',
        'fa fa-drum-steelpan',
        'fa fa-drumstick-bite',
        'fab fa-drupal',
        'fa fa-dumbbell',
        'fa fa-dumpster',
        'fa fa-dumpster-fire',
        'fa fa-dungeon',
        'fab fa-dyalog',
        'fab fa-earlybirds',
        'fab fa-ebay',
        'fab fa-edge',
        'fa fa-edit',
        'fa fa-egg',
        'fa fa-eject',
        'fab fa-elementor',
        'fa fa-ellipsis-h',
        'fa fa-ellipsis-v',
        'fab fa-ello',
        'fab fa-ember',
        'fab fa-empire',
        'fa fa-envelope',
        'fa fa-envelope pe-open',
        'fa fa-envelope pe-open-text',
        'fa fa-envelope pe-square',
        'fab fa-envira',
        'fa fa-equals',
        'fa fa-eraser',
        'fab fa-erlang',
        'fab fa-ethereum',
        'fa fa-ethernet',
        'fab fa-etsy',
        'fa fa-euro-sign',
        'fab fa-evernote',
        'fa fa-exchange-alt',
        'fa fa-exclamation',
        'fa fa-exclamation-circle',
        'fa fa-exclamation-triangle',
        'fa fa-expand',
        'fa fa-expand-arrows-alt',
        'fab fa-expeditedssl',
        'fa fa-external-link-alt',
        'fa fa-external-link-square-alt',
        'fa fa-eye',
        'fa fa-eye-dropper',
        'fa fa-eye-slash',
        'fab fa-facebook',
        'fab fa-facebook-f',
        'fab fa-facebook-messenger',
        'fab fa-facebook-square',
        'fab fa-fantasy-flight-games',
        'fa fa-fast-backward',
        'fa fa-fast-forward',
        'fa fa-fax',
        'fa fa-feather',
        'fa fa-feather-alt',
        'fab fa-fedex',
        'fab fa-fedora',
        'fa fa-female',
        'fa fa-fighter-jet',
        'fab fa-figma',
        'fa fa-file',
        'fa fa-file-alt',
        'fa fa-file-archive',
        'fa fa-file-audio',
        'fa fa-file-code',
        'fa fa-file-contract',
        'fa fa-file-csv',
        'fa fa-file-download',
        'fa fa-file-excel',
        'fa fa-file-export',
        'fa fa-file-image',
        'fa fa-file-import',
        'fa fa-file-invoice',
        'fa fa-file-invoice-dollar',
        'fa fa-file-medical',
        'fa fa-file-medical-alt',
        'fa fa-file-pdf',
        'fa fa-file-powerpoint',
        'fa fa-file-prescription',
        'fa fa-file-signature',
        'fa fa-file-upload',
        'fa fa-file-video',
        'fa fa-file-word',
        'fa fa-fill',
        'fa fa-fill-drip',
        'fa fa-film',
        'fa fa-filter',
        'fa fa-fingerprint',
        'fa fa-fire',
        'fa fa-fire-alt',
        'fa fa-fire-extinguisher',
        'fab fa-firefox',
        'fa fa-first-aid',
        'fab fa-first-order',
        'fab fa-first-order-alt',
        'fab fa-firstdraft',
        'fa fa-fish',
        'fa fa-fist-raised',
        'fa fa-flag',
        'fa fa-flag-checkered',
        'fa fa-flag-usa',
        'fa fa-flask',
        'fab fa-flickr',
        'fab fa-flipboard',
        'fa fa-flushed',
        'fab fa-fly',
        'fa fa-folder',
        'fa fa-folder-minus',
        'fa fa-folder-open',
        'fa fa-folder-plus',
        'fa fa-font',
        'fab fa-font-awesome',
        'fab fa-font-awesome-alt',
        'fab fa-font-awesome-flag',
        'fab fa-fonticons',
        'fab fa-fonticons-fi',
        'fa fa-football-ball',
        'fab fa-fort-awesome',
        'fab fa-fort-awesome-alt',
        'fab fa-forumbee',
        'fa fa-forward',
        'fab fa-foursquare',
        'fab fa-free-code-camp',
        'fab fa-freebsd',
        'fa fa-frog',
        'fa fa-frown',
        'fa fa-frown-open',
        'fab fa-fulcrum',
        'fa fa-funnel-dollar',
        'fa fa-futbol',
        'fab fa-galactic-republic',
        'fab fa-galactic-senate',
        'fa fa-gamepad',
        'fa fa-gas-pump',
        'fa fa-gavel',
        'fa fa-gem',
        'fa fa-genderless',
        'fab fa-get-pocket',
        'fab fa-gg',
        'fab fa-gg-circle',
        'fa fa-ghost',
        'fa fa-gift',
        'fa fa-gifts',
        'fab fa-git',
        'fab fa-git-alt',
        'fab fa-git-square',
        'fab fa-github',
        'fab fa-github-alt',
        'fab fa-github-square',
        'fab fa-gitkraken',
        'fab fa-gitlab',
        'fab fa-gitter',
        'fa fa-glass-cheers',
        'fa fa-glass-martini',
        'fa fa-glass-martini-alt',
        'fa fa-glass-whiskey',
        'fa fa-glasses',
        'fab fa-glide',
        'fab fa-glide-g',
        'fa fa-globe',
        'fa fa-globe-africa',
        'fa fa-globe-americas',
        'fa fa-globe-asia',
        'fa fa-globe-europe',
        'fab fa-gofore',
        'fa fa-golf-ball',
        'fab fa-goodreads',
        'fab fa-goodreads-g',
        'fab fa-google',
        'fab fa-google-drive',
        'fab fa-google-play',
        'fab fa-google-plus',
        'fab fa-google-plus-g',
        'fab fa-google-plus-square',
        'fab fa-google-wallet',
        'fa fa-gopuram',
        'fa fa-graduation-cap',
        'fab fa-gratipay',
        'fab fa-grav',
        'fa fa-greater-than',
        'fa fa-greater-than-equal',
        'fa fa-grimace',
        'fa fa-grin',
        'fa fa-grin-alt',
        'fa fa-grin-beam',
        'fa fa-grin-beam-sweat',
        'fa fa-grin-hearts',
        'fa fa-grin-squint',
        'fa fa-grin-squint-tears',
        'fa fa-grin-stars',
        'fa fa-grin-tears',
        'fa fa-grin-tongue',
        'fa fa-grin-tongue-squint',
        'fa fa-grin-tongue-wink',
        'fa fa-grin-wink',
        'fa fa-grip-horizontal',
        'fa fa-grip-lines',
        'fa fa-grip-lines-vertical',
        'fa fa-grip-vertical',
        'fab fa-gripfire',
        'fab fa-grunt',
        'fa fa-guitar',
        'fab fa-gulp',
        'fa fa-h-square',
        'fab fa-hacker-news',
        'fab fa-hacker-news-square',
        'fab fa-hackerrank',
        'fa fa-hamburger',
        'fa fa-hammer',
        'fa fa-hamsa',
        'fa fa-hand-holding',
        'fa fa-hand-holding-heart',
        'fa fa-hand-holding-usd',
        'fa fa-hand-lizard',
        'fa fa-hand-middle-finger',
        'fa fa-hand-paper',
        'fa fa-hand-peace',
        'fa fa-hand-point-down',
        'fa fa-hand-point-left',
        'fa fa-hand-point-right',
        'fa fa-hand-point-up',
        'fa fa-hand-pointer',
        'fa fa-hand-rock',
        'fa fa-hand-scissors',
        'fa fa-hand-spock',
        'fa fa-hands',
        'fa fa-hands-helping',
        'fa fa-handshake',
        'fa fa-hanukiah',
        'fa fa-hard-hat',
        'fa fa-hashtag',
        'fa fa-hat-wizard',
        'fa fa-haykal',
        'fa fa-hdd',
        'fa fa-heading',
        'fa fa-headphones',
        'fa fa-headphones-alt',
        'fa fa-headset',
        'fa fa-heart',
        'fa fa-heart-broken',
        'fa fa-heartbeat',
        'fa fa-helicopter',
        'fa fa-highlighter',
        'fa fa-hiking',
        'fa fa-hippo',
        'fab fa-hips',
        'fab fa-hire-a-helper',
        'fa fa-history',
        'fa fa-hockey-puck',
        'fa fa-holly-berry',
        'fa fa-home',
        'fab fa-hooli',
        'fab fa-hornbill',
        'fa fa-horse',
        'fa fa-horse-head',
        'fa fa-hospital',
        'fa fa-hospital-alt',
        'fa fa-hospital-symbol',
        'far fa-hospital',
        'fa fa-hot-tub',
        'fa fa-hotdog',
        'fa fa-hotel',
        'fas fa-hotel',
        'fab fa-hotjar',
        'fa fa-hourglass-end',
        'fa fa-hourglass-half',
        'fa fa-hourglass-start',
        'fa fa-house-damage',
        'fab fa-houzz',
        'fa fa-hryvnia',
        'fab fa-html5',
        'fab fa-hubspot',
        'fa fa-i-cursor',
        'fa fa-ice-cream',
        'fa fa-icicles',
        'fa fa-icons',
        'fa fa-id-badge',
        'fa fa-id-card',
        'fa fa-id-card-alt',
        'fa fa-igloo',
        'fa fa-image',
        'fa fa-images',
        'fab fa-imdb',
        'fa fa-inbox',
        'fa fa-indent',
        'fa fa-industry',
        'fa fa-infinity',
        'fa fa-info',
        'fa fa-info-circle',
        'fab fa-instagram',
        'fab fa-intercom',
        'fab fa-internet-explorer',
        'fab fa-invision',
        'fab fa-ioxhost',
        'fa fa-italic',
        'fab fa-itch-io',
        'fab fa-itunes',
        'fab fa-itunes-note',
        'fab fa-java',
        'fa fa-jedi',
        'fab fa-jedi-order',
        'fab fa-jenkins',
        'fab fa-jira',
        'fab fa-joget',
        'fa fa-joint',
        'fab fa-joomla',
        'fa fa-journal-whills',
        'fab fa-js',
        'fab fa-js-square',
        'fab fa-jsfiddle',
        'fa fa-kaaba',
        'fab fa-kaggle',
        'fa fa-key',
        'fab fa-keybase',
        'fa fa-keyboard',
        'fab fa-keycdn',
        'fa fa-khanda',
        'fab fa-kickstarter',
        'fab fa-kickstarter-k',
        'fa fa-kiss',
        'fa fa-kiss-beam',
        'fa fa-kiss-wink-heart',
        'fa fa-kiwi-bird',
        'fab fa-korvue',
        'fa fa-landmark',
        'fa fa-language',
        'fa fa-laptop',
        'fa fa-laptop-code',
        'fa fa-laptop-medical',
        'fab fa-laravel',
        'fab fa-lastfm',
        'fab fa-lastfm-square',
        'fa fa-laugh',
        'fa fa-laugh-beam',
        'fa fa-laugh-squint',
        'fa fa-laugh-wink',
        'fa fa-layer-group',
        'fa fa-leaf',
        'fab fa-leanpub',
        'fa fa-lemon',
        'fab fa-less',
        'fa fa-less-than',
        'fa fa-less-than-equal',
        'fa fa-level-down-alt',
        'fa fa-level-up-alt',
        'fa fa-life-ring',
        'fa fa-lightbulb',
        'fab fa-line',
        'fa fa-link',
        'fab fa-linkedin',
        'fab fa-linkedin-in',
        'fab fa-linode',
        'fab fa-linux',
        'fa fa-lira-sign',
        'fa fa-list',
        'fa fa-list-alt',
        'fa fa-list-ol',
        'fa fa-list-ul',
        'fa fa-location-arrow',
        'fa fa-lock',
        'fa fa-lock-open',
        'fa fa-long-arrow-alt-down',
        'fa fa-long-arrow-alt-left',
        'fa fa-long-arrow-alt-right',
        'fa fa-long-arrow-alt-up',
        'fa fa-low-vision',
        'fa fa-luggage-cart',
        'fab fa-lyft',
        'fab fa-magento',
        'fa fa-magic',
        'fa fa-magnet',
        'fa fa-mail-bulk',
        'fab fa-mailchimp',
        'fa fa-male',
        'fab fa-mandalorian',
        'fa fa-map',
        'fa fa-map-marked',
        'fa fa-map-marked-alt',
        'fa fa-map-marker',
        'fa fa-map-marker-alt',
        'fa fa-map-pin',
        'fa fa-map-signs',
        'fab fa-markdown',
        'fa fa-marker',
        'fa fa-mars',
        'fa fa-mars-double',
        'fa fa-mars-stroke',
        'fa fa-mars-stroke-h',
        'fa fa-mars-stroke-v',
        'fa fa-mask',
        'fab fa-mastodon',
        'fab fa-maxcdn',
        'fa fa-medal',
        'fab fa-medapps',
        'fab fa-medium',
        'fab fa-medium-m',
        'fa fa-medkit',
        'fab fa-medrt',
        'fab fa-meetup',
        'fab fa-megaport',
        'fa fa-meh',
        'fa fa-meh-blank',
        'fa fa-meh-rolling-eyes',
        'fa fa-memory',
        'fab fa-mendeley',
        'fa fa-menorah',
        'fa fa-mercury',
        'fa fa-meteor',
        'fa fa-microchip',
        'fa fa-microphone',
        'fa fa-microphone-alt',
        'fa fa-microphone-alt-slash',
        'fa fa-microphone-slash',
        'fa fa-microscope',
        'fab fa-microsoft',
        'fa fa-minus',
        'fa fa-minus-circle',
        'fa fa-minus-square',
        'fa fa-mitten',
        'fab fa-mix',
        'fab fa-mixcloud',
        'fab fa-mizuni',
        'fa fa-mobile',
        'fa fa-mobile-alt',
        'fab fa-modx',
        'fab fa-monero',
        'fa fa-money-bill',
        'fa fa-money-bill-alt',
        'fa fa-money-bill-wave',
        'fa fa-money-bill-wave-alt',
        'fa fa-money-check',
        'fa fa-money-check-alt',
        'fa fa-monument',
        'fa fa-moon',
        'fa fa-mortar-pestle',
        'fa fa-mosque',
        'fa fa-motorcycle',
        'fa fa-mountain',
        'fa fa-mouse-pointer',
        'fa fa-mug-hot',
        'fa fa-music',
        'fab fa-napster',
        'fab fa-neos',
        'fa fa-network-wired',
        'fa fa-neuter',
        'fa fa-newspaper',
        'fab fa-nimblr',
        'fab fa-node',
        'fab fa-node-js',
        'fa fa-not-equal',
        'fa fa-notes-medical',
        'fab fa-npm',
        'fab fa-ns8',
        'fab fa-nutritionix',
        'fa fa-object-group',
        'fa fa-object-ungroup',
        'fab fa-odnoklassniki',
        'fab fa-odnoklassniki-square',
        'fa fa-oil-can',
        'fab fa-old-republic',
        'fa fa-om',
        'fab fa-opencart',
        'fab fa-openid',
        'fab fa-opera',
        'fab fa-optin-monster',
        'fab fa-osi',
        'fa fa-otter',
        'fa fa-outdent',
        'fab fa-page4',
        'fab fa-pagelines',
        'fa fa-pager',
        'fa fa-paint-brush',
        'fa fa-paint-roller',
        'fa fa-palette',
        'fab fa-palfed',
        'fa fa-pallet',
        'fa fa-paper-plane',
        'fa fa-paperclip',
        'fa fa-parachute-box',
        'fa fa-paragraph',
        'fa fa-parking',
        'fa fa-passport',
        'fa fa-pastafarianism',
        'fa fa-paste',
        'fab fa-patreon',
        'fa fa-pause',
        'fa fa-pause-circle',
        'fa fa-paw',
        'fab fa-paypal',
        'fa fa-peace',
        'fa fa-pen',
        'fa fa-pen-alt',
        'fa fa-pen-fancy',
        'fa fa-pen-nib',
        'fa fa-pen-square',
        'fa fa-pencil-alt',
        'fa fa-pencil-ruler',
        'fab fa-penny-arcade',
        'fa fa-people-carry',
        'fa fa-pepper-hot',
        'fa fa-percent',
        'fa fa-percentage',
        'fab fa-periscope',
        'fa fa-person-booth',
        'fab fa-phabricator',
        'fab fa-phoenix-framework',
        'fab fa-phoenix-squadron',
        'fa fa-phone',
        'fa fa-phone-slash',
        'fa fa-phone-square',
        'fa fa-phone-volume',
        'fab fa-php',
        'fab fa-pied-piper',
        'fab fa-pied-piper-alt',
        'fab fa-pied-piper-hat',
        'fab fa-pied-piper-pp',
        'fa fa-piggy-bank',
        'fa fa-pills',
        'fab fa-pinterest',
        'fab fa-pinterest-p',
        'fab fa-pinterest-square',
        'fa fa-pizza-slice',
        'fa fa-place-of-worship',
        'fa fa-plane',
        'fa fa-plane-arrival',
        'fa fa-plane-departure',
        'fas fa-plane-departure',
        'fa fa-play',
        'fa fa-play-circle',
        'fab fa-playstation',
        'fa fa-plug',
        'fa fa-plus',
        'fa fa-plus-circle',
        'fa fa-plus-square',
        'fa fa-podcast',
        'fa fa-poll',
        'fa fa-poll-h',
        'fa fa-poo',
        'fa fa-poo-storm',
        'fa fa-poop',
        'fa fa-portrait',
        'fa fa-pound-sign',
        'fa fa-power-off',
        'fa fa-pray',
        'fa fa-praying-hands',
        'fa fa-prescription',
        'fa fa-prescription-bottle',
        'fa fa-prescription-bottle-alt',
        'fas fa-prescription-bottle-alt',
        'fa fa-print',
        'fa fa-procedures',
        'fab fa-product-hunt',
        'fa fa-project-diagram',
        'fab fa-pushed',
        'fa fa-puzzle-piece',
        'fab fa-python',
        'fab fa-qq',
        'fa fa-qrcode',
        'fa fa-question',
        'fa fa-question-circle',
        'fa fa-quidditch',
        'fab fa-quinscape',
        'fab fa-quora',
        'fa fa-quote-left',
        'fa fa-quote-right',
        'fa fa-quran',
        'fab fa-r-project',
        'fa fa-radiation',
        'fa fa-radiation-alt',
        'fa fa-rainbow',
        'fa fa-random',
        'fab fa-raspberry-pi',
        'fab fa-ravelry',
        'fab fa-react',
        'fab fa-reacteurope',
        'fab fa-readme',
        'fab fa-rebel',
        'fa fa-receipt',
        'fab fa-record-vinyl',
        'fa fa-recycle',
        'fab fa-red-river',
        'fab fa-reddit',
        'fab fa-reddit-alien',
        'fab fa-reddit-square',
        'fab fa-redhat',
        'fa fa-redo',
        'fa fa-redo-alt',
        'fa fa-registered',
        'fab fa-renren',
        'fa fa-reply',
        'fa fa-reply-all',
        'fab fa-replyd',
        'fa fa-republican',
        'fab fa-researchgate',
        'fab fa-resolving',
        'fa fa-restroom',
        'fa fa-retweet',
        'fab fa-rev',
        'fa fa-ribbon',
        'fa fa-ring',
        'fa fa-road',
        'fa fa-robot',
        'fa fa-rocket',
        'fab fa-rocketchat',
        'fab fa-rockrms',
        'fa fa-route',
        'fa fa-rss',
        'fa fa-rss-square',
        'fa fa-ruble-sign',
        'fa fa-ruler',
        'fa fa-ruler-combined',
        'fa fa-ruler-horizontal',
        'fa fa-ruler-vertical',
        'fa fa-running',
        'fa fa-rupee-sign',
        'fa fa-sad-cry',
        'fa fa-sad-tear',
        'fab fa-safari',
        'fab fa-salesforce',
        'fab fa-sass',
        'fa fa-satellite',
        'fa fa-satellite-dish',
        'fa fa-save',
        'fab fa-schlix',
        'fa fa-school',
        'fas fa-school',
        'fa fa-screwdriver',
        'fab fa-scribd',
        'fa fa-scroll',
        'fa fa-sd-card',
        'fa fa-search',
        'fa fa-search-dollar',
        'fa fa-search-location',
        'fa fa-search-minus',
        'fa fa-search-plus',
        'fab fa-searchengin',
        'fa fa-seedling',
        'fab fa-sellcast',
        'fab fa-sellsy',
        'fa fa-server',
        'fab fa-servicestack',
        'fa fa-shapes',
        'fa fa-share',
        'fa fa-share-alt',
        'fa fa-share-alt-square',
        'fa fa-share-square',
        'fa fa-shekel-sign',
        'fa fa-shield-alt',
        'fa fa-ship',
        'fa fa-shipping-fast',
        'fab fa-shirtsinbulk',
        'fa fa-shoe-prints',
        'fa fa-shopping-bag',
        'fa fa-shopping-basket',
        'fa fa-shopping-cart',
        'fab fa-shopware',
        'fa fa-shower',
        'fa fa-shuttle-van',
        'fa fa-sign',
        'fa fa-sign-in-alt',
        'fa fa-sign-language',
        'fa fa-sign-out-alt',
        'fa fa-signal',
        'fa fa-signature',
        'fa fa-sim-card',
        'fab fa-simplybuilt',
        'fab fa-sistrix',
        'fa fa-sitemap',
        'fab fa-sith',
        'fa fa-skating',
        'fab fa-sketch',
        'fa fa-skiing',
        'fa fa-skiing-nordic',
        'fa fa-skull',
        'fa fa-skull-crossbones',
        'fab fa-skyatlas',
        'fab fa-skype',
        'fab fa-slack',
        'fab fa-slack-hash',
        'fa fa-slash',
        'fa fa-sleigh',
        'fa fa-sliders-h',
        'fab fa-slideshare',
        'fa fa-smile',
        'fa fa-smile-beam',
        'fa fa-smile-wink',
        'fa fa-smog',
        'fa fa-smoking',
        'fa fa-smoking-ban',
        'fa fa-sms',
        'fab fa-snapchat',
        'fab fa-snapchat-ghost',
        'fab fa-snapchat-square',
        'fa fa-snowboarding',
        'fa fa-snowflake',
        'fa fa-snowman',
        'fa fa-snowplow',
        'fa fa-socks',
        'fa fa-solar-panel',
        'fa fa-sort',
        'fa fa-sort-alpha-down',
        'fa fa-sort-alpha-up',
        'fa fa-sort-amount-down',
        'fa fa-sort-amount-up',
        'fa fa-sort-down',
        'fa fa-sort-numeric-down',
        'fa fa-sort-numeric-up',
        'fa fa-sort-up',
        'fab fa-soundcloud',
        'fab fa-sourcetree',
        'fa fa-spa',
        'fa fa-space-shuttle',
        'fab fa-speakap',
        'fab fa-speaker-deck',
        'fa fa-spider',
        'fa fa-spinner',
        'fa fa-splotch',
        'fab fa-spotify',
        'fa fa-spray-can',
        'fa fa-square',
        'fa fa-square-full',
        'fa fa-square-root-alt',
        'fab fa-squarespace',
        'fab fa-stack-exchange',
        'fab fa-stack-overflow',
        'fab fa-stackpath',
        'fa fa-stamp',
        'fa fa-star',
        'fa fa-star-and-crescent',
        'fa fa-star-half',
        'fa fa-star-half-alt',
        'fa fa-star-of-david',
        'fa fa-star-of-life',
        'fab fa-staylinked',
        'fab fa-steam',
        'fab fa-steam-square',
        'fab fa-steam-symbol',
        'fa fa-step-backward',
        'fa fa-step-forward',
        'fa fa-stethoscope',
        'fab fa-sticker-mule',
        'fa fa-sticky-note',
        'fa fa-stop',
        'fa fa-stop-circle',
        'fa fa-stopwatch',
        'fa fa-store',
        'fa fa-store-alt',
        'fab fa-strava',
        'fa fa-stream',
        'fa fa-street-view',
        'fa fa-strikethrough',
        'fab fa-stripe',
        'fab fa-stripe pe-s',
        'fa fa-stroopwafel',
        'fab fa-studiovinari',
        'fab fa-stumbleupon',
        'fab fa-stumbleupon-circle',
        'fa fa-subscript',
        'fa fa-subway',
        'fas fa-subway',
        'fa fa-suitcase',
        'fa fa-suitcase-rolling',
        'fa fa-sun',
        'fab fa-superpowers',
        'fa fa-superscript',
        'fab fa-supple',
        'fa fa-surprise',
        'fab fa-suse',
        'fa fa-swatchbook',
        'fa fa-swimmer',
        'fas fa-swimmer',
        'fa fa-swimming-pool',
        'fab fa-symfony',
        'fa fa-synagogue',
        'fa fa-sync',
        'fa fa-sync-alt',
        'fa fa-syringe',
        'fa fa-table',
        'fa fa-table-tennis',
        'fa fa-tablet',
        'fa fa-tablet-alt',
        'fa fa-tablets',
        'fa fa-tachometer-alt',
        'fa fa-tag',
        'fa fa-tags',
        'fa fa-tape',
        'fa fa-tasks',
        'fa fa-taxi',
        'fab fa-teamspeak',
        'fa fa-teeth',
        'fa fa-teeth-open',
        'fab fa-telegram',
        'fab fa-telegram-plane',
        'fa fa-temperature-high',
        'fa fa-temperature-low',
        'fab fa-tencent-weibo',
        'fa fa-tenge',
        'fa fa-terminal',
        'fa fa-text-height',
        'fa fa-text-width',
        'fa fa-th',
        'fa fa-th-large',
        'fa fa-th-list',
        'fab fa-the-red-yeti',
        'fa fa-theater-masks',
        'fab fa-themeco',
        'fab fa-themeisle',
        'fa fa-thermometer',
        'fa fa-thermometer-empty',
        'fa fa-thermometer-full',
        'fa fa-thermometer-half',
        'fa fa-thermometer-quarter',
        'fa fa-thermometer-three-quarters',
        'fab fa-think-peaks',
        'fa fa-thumbs-down',
        'fa fa-thumbs-up',
        'fa fa-thumbtack',
        'fa fa-ticket-alt',
        'fa fa-times',
        'fa fa-times-circle',
        'fa fa-tint',
        'fa fa-tint-slash',
        'fa fa-tired',
        'fa fa-toggle-off',
        'fa fa-toggle-on',
        'fa fa-toilet',
        'fa fa-toilet-paper',
        'fa fa-toolbox',
        'fa fa-tools',
        'fa fa-tooth',
        'fa fa-torah',
        'fa fa-torii-gate',
        'fa fa-tractor',
        'fab fa-trade-federation',
        'fa fa-trademark',
        'fa fa-traffic-light',
        'fa fa-train',
        'fa fa-tram',
        'fa fa-transgender',
        'fa fa-transgender-alt',
        'fa fa-trash',
        'fa fa-trash-alt',
        'fa fa-trash-restore',
        'fa fa-trash-restore-alt',
        'fa fa-tree',
        'fab fa-trello',
        'fab fa-tripadvisor',
        'fa fa-trophy',
        'fa fa-truck',
        'fa fa-truck-loading',
        'fa fa-truck-monster',
        'fa fa-truck-moving',
        'fa fa-truck-pickup',
        'fa fa-tshirt',
        'fa fa-tty',
        'fab fa-tumblr',
        'fab fa-tumblr-square',
        'fa fa-tv',
        'fab fa-twitch',
        'fab fa-twitter',
        'fab fa-twitter-square',
        'fab fa-typo3',
        'fab fa-uber',
        'fab fa-ubuntu',
        'fab fa-uikit',
        'fa fa-umbrella',
        'fa fa-umbrella fa-beach',
        'fas fa-umbrella-beach',
        'fa fa-underline',
        'fa fa-undo',
        'fa fa-undo-alt',
        'fab fa-uniregistry',
        'fa fa-universal-access',
        'fa fa-university',
        'fas fa-university',
        'fa fa-unlink',
        'fa fa-unlock',
        'fa fa-unlock-alt',
        'fab fa-untappd',
        'fa fa-upload',
        'fab fa-ups',
        'fab fa-usb',
        'fa fa-user',
        'fa fa-user-alt',
        'fa fa-user-alt-slash',
        'fa fa-user-astronaut',
        'fa fa-user-check',
        'fa fa-user-circle',
        'fa fa-user-clock',
        'fa fa-user-cog',
        'fa fa-user-edit',
        'fa fa-user-friends',
        'fa fa-user-graduate',
        'fa fa-user-injured',
        'fa fa-user-lock',
        'fa fa-user-md',
        'fa fa-user-minus',
        'fa fa-user-ninja',
        'fa fa-user-nurse',
        'fa fa-user-plus',
        'fa fa-user-secret',
        'fas fa-user-secret',
        'fa fa-user-shield',
        'fa fa-user-slash',
        'fa fa-user-tag',
        'fa fa-user-tie',
        'fa fa-user-times',
        'fa fa-users',
        'fa fa-users-cog',
        'fab fa-usps',
        'fab fa-ussunnah',
        'fa fa-utensil-spoon',
        'fa fa-utensils',
        'fab fa-vaadin',
        'fa fa-vector-square',
        'fa fa-venus',
        'fa fa-venus-double',
        'fa fa-venus-mars',
        'fab fa-viacoin',
        'fab fa-viadeo',
        'fab fa-viadeo-square',
        'fa fa-vial',
        'fa fa-vials',
        'fab fa-viber',
        'fa fa-video',
        'fa fa-video-slash',
        'fa fa-vihara',
        'fab fa-vimeo',
        'fab fa-vimeo-square',
        'fab fa-vimeo-v',
        'fab fa-vine',
        'fab fa-vk',
        'fab fa-vnv',
        'fa fa-voicemail',
        'fa fa-volleyball-ball',
        'fa fa-volume-down',
        'fa fa-volume-mute',
        'fa fa-volume-off',
        'fa fa-volume-up',
        'fa fa-vote-yea',
        'fa fa-vr-cardboard',
        'fab fa-vuejs',
        'fa fa-walking',
        'fa fa-wallet',
        'fa fa-warehouse',
        'fa fa-water',
        'fa fa-wave-square',
        'fab fa-waze',
        'fab fa-weebly',
        'fab fa-weibo',
        'fa fa-weight',
        'fa fa-weight-hanging',
        'fab fa-weixin',
        'fab fa-whatsapp',
        'fab fa-whatsapp-square',
        'fa fa-wheelchair',
        'fab fa-whmcs',
        'fa fa-wifi',
        'fas fa-wifi',
        'fab fa-wikipedia-w',
        'fa fa-wind',
        'fa fa-window-close',
        'fa fa-window-maximize',
        'fa fa-window-minimize',
        'fa fa-window-restore',
        'fab fa-windows',
        'fa fa-wine-bottle',
        'fa fa-wine-glass',
        'fa fa-wine-glass-alt',
        'fab fa-wix',
        'fab fa-wizards-of-the-coast',
        'fab fa-wolf-pack-battalion',
        'fa fa-won-sign',
        'fab fa-wordpress',
        'fab fa-wordpress-simple',
        'fab fa-wpbeginner',
        'fab fa-wpexplorer',
        'fab fa-wpforms',
        'fab fa-wpressr',
        'fa fa-wrench',
        'fa fa-x-ray',
        'fab fa-xbox',
        'fab fa-xing',
        'fab fa-xing-square',
        'fab fa-y-combinator',
        'fab fa-yahoo',
        'fab fa-yammer',
        'fab fa-yandex',
        'fab fa-yandex-international',
        'fab fa-yarn',
        'fab fa-yelp',
        'fa fa-yen-sign',
        'fa fa-yin-yang',
        'fab fa-yoast',
        'fab fa-youtube',
        'fab fa-youtube-square',
        'fab fa-zhihu',
        'fa fa-glass',
        'fab fa-meetup',
        'far fa-file',
        'far fa-clock',
        'fa fa-repeat',
        'fa fa-pencil',
        'fa fa-arrows',
        'fa fa-arrows-v',
        'fa fa-arrows-h',
        'fa fa-sign-out',
        'fa fa-external-link',
        'fa fa-sign-in',
        'fab fa-github-square',
        'fab fa-twitter',
        'fab fa-facebook',
        'fab fa-facebook-f',
        'fab fa-github',
        'fa fa-tachometer',
        'fa fa-exchange',
        'fa fa-cloud-download',
        'fa fa-cloud-upload',
        'fa fa-shield',
        'fab fa-maxcdn',
        'fab fa-html5',
        'fab fa-css3',
        'fa fa-ticket',
        'fa fa-level-up',
        'fa fa-level-down',
        'fab fa-tumblr',
        'fab fa-tumblr-square',
        'fa fa-long-arrow-down',
        'fa fa-long-arrow-up',
        'fa fa-long-arrow-left',
        'fa fa-long-arrow-right',
        'fab fa-apple',
        'fab fa-windows',
        'fab fa-android',
        'fab fa-linux',
        'fab fa-dribble',
        'fab fa-skype',
        'fab fa-foursquare',
        'fab fa-trello',
        'fab fa-gratipay',
        'fa fa-diamond',
        'fa fa-hourglass',
        'fab fa-superpowers',
        'fab fa-wpexplorer',
        'fab fa-spotify',
    ];

    let initIconsField = function () {
        $('.icon-select').each(function (index, el) {
            let value = $(el).children('option:selected').val();

            let options = '';

            if (!value) {
                options = '<option value="">&nbsp;</option>';
            }

            icons.forEach(function (value) {
                options += '<option value="' + value + '">' + value + '</option>';
            });

            $(el).html(options);
            $(el).val(value);

            let select2Options = {
                templateResult: function (state) {
                    if (!state.id) {
                        return state.text;
                    }
                    return $('<span><i class="' + state.id + '"></i></span>&nbsp; ' + state.text + '</span>');
                },
                width: '100%',
                templateSelection: function (state) {
                    if (!state.id) {
                        return state.text;
                    }
                    return $('<span><i class="' + state.id + '"></i></span>&nbsp; ' + state.text + '</span>');
                },
            };

            let parent = $(el).closest('.modal');
            if (parent.length) {
                select2Options.dropdownParent = parent;
            }

            $(el).select2(select2Options);
        });
    }

    initIconsField();

    document.addEventListener('core-init-resources', function(e) {
        initIconsField();
    });
});
